package net.w_horse.excelpojo;


import org.apache.log4j.xml.DOMConfigurator;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFDataFormatter;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.junit.BeforeClass;

public abstract class AbstractTest {


	@BeforeClass
	public static void tearDown() {
		DOMConfigurator.configure("config/log4j.xml");
	}

	protected HSSFCell getCell(HSSFSheet sheet, int rowIndex, int colIndex) {
		HSSFRow row = sheet.getRow(rowIndex -1);
		if (row == null) return null;
		return row.getCell(colIndex -1);
	}
	protected Object getCellValue(HSSFSheet sheet, int rowIndex, int colIndex,
			int cellType) {
		return getCellValue(getCell(sheet, rowIndex, colIndex), cellType);
	}

	protected static final int CELL_TYPE_STRING = 0;
	protected static final int CELL_TYPE_INT = 1;
	protected static final int CELL_TYPE_DOUBLE = 2;
	protected static final int CELL_TYPE_DATE_STR = 3;
	protected static final int CELL_TYPE_BOOLEAN = 4;

	public AbstractTest() {
		super();
	}

	protected Object getCellValue(HSSFCell cell, int cellType) {
		// NULL͋󕶎ϊ
		if(cell == null){
			return null;
		}

		switch(cellType){
		case CELL_TYPE_STRING:
		case CELL_TYPE_DATE_STR:
			return cell.getRichStringCellValue().getString();
		case CELL_TYPE_INT:
		case CELL_TYPE_DOUBLE:
			return getNumericType(cell, cellType);
		case CELL_TYPE_BOOLEAN:
			return Boolean.parseBoolean(cell.getRichStringCellValue().getString());
		default:
			return null;
		}
	}

	private Object getNumericType(HSSFCell cell, int cellType) {
		HSSFDataFormatter formatter = new HSSFDataFormatter();
	    String val = formatter.formatCellValue(cell);
	    if (val.endsWith("_ ")) {
	    	val = val.substring(0, val.length() -2);
	    }
	    if (cellType == CELL_TYPE_INT) {
	    	return Integer.parseInt(val);
	    } else {
	       	return Double.parseDouble(val);
	    }
	}

}